#include <vector>
#include <iostream>
using namespace std;

struct tacka
{
    long long int x;
    long long int y;
};

bool nalevo(tacka a, tacka b, tacka c)
{
    return ((b.y - a.y) * (c.x - b.x) - (b.x - a.x) * (c.y - b.y)) < 0;
}


long long int povrsina_omotaca(vector<tacka> tacke, long long int n, long long int najlevlja, long long int preskoci)
{
    vector<tacka> omotac;

    long long int prva = najlevlja, druga;
    do
    {
        omotac.push_back(tacke[prva]);

        druga = (prva + 1) % n;
        for (long long int i = 0; i < n; i++)
        {
            if (i == preskoci)
                continue;

            if (nalevo(tacke[prva], tacke[i], tacke[druga]))
                druga = i;
        }

        prva = druga;

    }
    while (prva != najlevlja);


    long long int res = 0;
    for (unsigned long long int i = 0; i < omotac.size(); i++)
    {
        tacka prva;
        if (i != 0)
            prva = omotac[i - 1];
        else
            prva = omotac[omotac.size() - 1];
        tacka druga = omotac[i];
        res += (prva.x - druga.x) * (prva.y + druga.y)/2;
    }

    return abs(res);
}


int main()
{

    long long int n;
    cin >> n;

    vector<tacka> tacke;

    long long int najlevlja = 0;
    long long int druganajlevlja = -1;

    for (long long int i = 0; i < n; i++)
    {
        long long int a, b;
        cin >> a >> b;

        tacka s;
        s.x = a;
        s.y = b;
        tacke.push_back(s);

        if (i > 0)
        {
            if (tacke[i].x < tacke[najlevlja].x)
            {
                druganajlevlja = najlevlja;
                najlevlja = i;
            }
            else if (druganajlevlja == -1 || tacke[i].x < tacke[druganajlevlja].x)
            {
                druganajlevlja = i;
            }
        }

    }

    long long int minipovrs = 0;

    for (long long int i = 0; i < n; i++)
    {
        long long int leva = najlevlja;
        if (leva == i)
            leva = druganajlevlja;

        long long int p = povrsina_omotaca(tacke, n, leva, i);
        if (i == 0 || p < minipovrs)
        {
            minipovrs = p;
        }
    }

    cout << minipovrs;


    return 0;
}